VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DlxOCX32.ocx"
Begin VB.Form Form1 
   Caption         =   "Variable Duty Cycle Pulse Train with KPCI3100 Series"
   ClientHeight    =   3630
   ClientLeft      =   1830
   ClientTop       =   2130
   ClientWidth     =   8025
   LinkTopic       =   "Form1"
   ScaleHeight     =   3630
   ScaleWidth      =   8025
   Begin VB.ComboBox devNum 
      Height          =   315
      Left            =   2520
      TabIndex        =   12
      Text            =   "0"
      Top             =   720
      Width           =   735
   End
   Begin VB.Frame Frame2 
      Caption         =   "Waveform Frequency"
      Height          =   1095
      Left            =   5160
      TabIndex        =   9
      Top             =   1200
      Width           =   2175
      Begin VB.OptionButton opt5KHz 
         Caption         =   "5.0 KHz"
         Height          =   255
         Left            =   240
         TabIndex        =   11
         Top             =   600
         Width           =   1335
      End
      Begin VB.OptionButton opt1KHz 
         Caption         =   "1.0 KHz"
         Height          =   255
         Left            =   240
         TabIndex        =   10
         Top             =   240
         Value           =   -1  'True
         Width           =   1455
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Duty Cycle"
      Height          =   1095
      Left            =   2640
      TabIndex        =   6
      Top             =   1200
      Width           =   2175
      Begin VB.OptionButton optNINETY 
         Caption         =   "90% ON/ 10% OFF"
         Height          =   375
         Left            =   240
         TabIndex        =   8
         Top             =   600
         Width           =   1695
      End
      Begin VB.OptionButton optTEN 
         Caption         =   "10 % ON/ 90% Off"
         Height          =   255
         Left            =   240
         TabIndex        =   7
         Top             =   240
         Value           =   -1  'True
         Width           =   1695
      End
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      Height          =   495
      Left            =   6720
      TabIndex        =   5
      Top             =   2880
      Width           =   975
   End
   Begin VB.TextBox txtStatus 
      Enabled         =   0   'False
      Height          =   285
      Left            =   360
      TabIndex        =   4
      Top             =   2760
      Width           =   4215
   End
   Begin VB.CommandButton cmdOpen 
      Caption         =   "Open Driver"
      Height          =   375
      Left            =   360
      TabIndex        =   2
      Top             =   720
      Width           =   1815
   End
   Begin VB.CommandButton cmdStop 
      Caption         =   "Stop VDC on CT0"
      Enabled         =   0   'False
      Height          =   375
      Left            =   360
      TabIndex        =   1
      Top             =   2160
      Width           =   1815
   End
   Begin VB.CommandButton cmdStart 
      Caption         =   "Start VDC on CT0"
      Enabled         =   0   'False
      Height          =   375
      Left            =   360
      TabIndex        =   0
      Top             =   1440
      Width           =   1815
   End
   Begin DlsrLib.DriverLINXSR DriverLINXSR1 
      Left            =   5760
      Top             =   2760
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Device Number: "
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   165
      Left            =   2520
      TabIndex        =   13
      Top             =   480
      Width           =   1260
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   "  KEITHLEY  "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000E&
      Height          =   360
      Left            =   360
      TabIndex        =   3
      Top             =   120
      Width           =   1845
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
' this example was written in VB6
' it was tested with KPCI-3104 using 3100-850A03 driver in Win2KSP1

Private Sub cmdExit_Click()
' just in case, stop any active task
With DriverLINXSR1
.Req_op = DL_STOP
.Refresh
End With
' unload driver
DriverLINXSR1.Req_DLL_name = ""
End
End Sub

Private Sub cmdOpen_Click()
Dim DeviceNumber As Integer
'get device number from the combo box on the form
DeviceNumber = CInt(devNum.Text)
With DriverLINXSR1
.Req_DLL_name = "kpci3100"
.Req_mode = DL_OTHER
.Req_op = DL_INITIALIZE
.Req_subsystem = DL_DEVICE
.Req_device = DeviceNumber
.Refresh
End With
If DriverLINXSR1.Res_result = DL_NoErr Then
cmdOpen.Enabled = False
cmdStart.Enabled = True
txtStatus.Text = DriverLINXSR1.Message
Else
txtStatus.Text = DriverLINXSR1.Message
End If
Form1.SetFocus
End Sub

Private Sub cmdStart_Click()
Dim Duty As Single
Dim Period As Single
If opt1KHz.Value = True Then
Period = 0.001  ' 1 msec (1KHz) period
Else
Period = 0.0002  ' 200 micro second period
End If
' the allowable range on the Period:
'  if using the internal1 timebase which is 20MHz, this period can be no
'  less than 305 Hz
'  305 Hz -----> 0.0032 sec period
'  1000 Hz -----> 0.001 sec period
'  5000 Hz -----> 0.0002 sec period
'  etc.

With DriverLINXSR1
.Req_op = DL_START
.Req_subsystem = DL_CT
.Req_mode = DL_POLLED
.Sel_buf_N = 0
.Sel_chan_N = 0
.Evt_Str_type = DL_COMMAND
.Evt_Tim_type = DL_RATEEVENT
.Evt_Tim_rateChannel = 0
.Evt_Tim_rateClock = DL_INTERNAL1
.Evt_Tim_rateGate = DL_DISABLED
.Evt_Tim_rateMode = DL_VDCGEN
.Evt_Tim_rateOutput = CT_Output_HiActive
.Evt_Tim_ratePeriod = .DLSecs2Tics(.Evt_Tim_rateChannel, Period)

If optTEN.Value = True Then
 Duty = 0.1 * Period   ' 10% of the 1 msec total period
Else
Duty = 0.9 * Period   ' 90% of the 1 msec total period
End If
.Evt_Tim_rateOnCount = .DLSecs2Tics(.Evt_Tim_rateChannel, Duty)
.Evt_Tim_ratePulses = 0
.Evt_Stp_type = DL_NULLEVENT
.Refresh
End With
If DriverLINXSR1.Res_result = DL_NoErr Then
cmdStop.Enabled = True
cmdStart.Enabled = False
txtStatus.Text = DriverLINXSR1.Message
Else
txtStatus.Text = DriverLINXSR1.Message
End If

End Sub

Private Sub cmdStop_Click()
With DriverLINXSR1
.Req_op = DL_STOP
.Refresh
End With
cmdStop.Enabled = False
cmdStart.Enabled = True
End Sub

Private Sub Form_Load()
' populate combo box with legal device numbers
devNum.AddItem "0", 0
devNum.AddItem "1", 1
devNum.AddItem "2", 2
devNum.AddItem "3", 3
devNum.AddItem "4", 4
devNum.AddItem "5", 5
' set it equal to first entry
devNum.ListIndex = 0
End Sub
